<?php
$pageTitle = 'Relatórios - Sistema de Vendas';
include 'templates/header.php';
?>

<div class="card">
    <div class="card-header">
        <h2 class="card-title">Relatórios</h2>
    </div>
    
    <div class="form-row mb-3">
        <div class="form-col">
            <label for="dataInicio" class="form-label">Data Início</label>
            <input type="date" id="dataInicio" class="form-control">
        </div>
        <div class="form-col">
            <label for="dataFim" class="form-label">Data Fim</label>
            <input type="date" id="dataFim" class="form-control">
        </div>
        <div class="form-col" style="flex: 0 0 auto; align-self: end;">
            <button class="btn btn-primary" onclick="aplicarFiltros()">Aplicar Filtros</button>
            <button class="btn btn-warning" onclick="limparFiltros()">Limpar</button>
        </div>
    </div>
</div>

<!-- Resumo Geral -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Resumo Geral</h3>
    </div>
    
    <div class="dashboard-grid">
        <div class="stat-card">
            <div class="stat-number" id="resumoVendas">-</div>
            <div class="stat-label">Total de Vendas</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-number" id="resumoFaturamento">-</div>
            <div class="stat-label">Faturamento</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-number" id="resumoTicketMedio">-</div>
            <div class="stat-label">Ticket Médio</div>
        </div>
        
        <div class="stat-card">
            <div class="stat-number" id="resumoEstoqueBaixo">-</div>
            <div class="stat-label">Produtos Estoque Baixo</div>
        </div>
    </div>
</div>

<!-- Vendas por Período -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Vendas por Período</h3>
        <button class="btn btn-primary btn-sm" onclick="exportarVendasPeriodo()">Exportar</button>
    </div>
    
    <div class="table-container">
        <table class="table">
            <thead>
                <tr>
                    <th>Data</th>
                    <th>Número de Vendas</th>
                    <th>Faturamento</th>
                </tr>
            </thead>
            <tbody id="vendasPeriodoTable">
                <tr>
                    <td colspan="3" class="text-center">Selecione um período para visualizar os dados</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<!-- Produtos Mais Vendidos -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Produtos Mais Vendidos</h3>
        <button class="btn btn-primary btn-sm" onclick="exportarProdutosMaisVendidos()">Exportar</button>
    </div>
    
    <div class="table-container">
        <table class="table">
            <thead>
                <tr>
                    <th>Produto</th>
                    <th>Quantidade Vendida</th>
                    <th>Faturamento</th>
                </tr>
            </thead>
            <tbody id="produtosMaisVendidosTable">
                <tr>
                    <td colspan="3" class="text-center">Carregando...</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<!-- Produtos com Estoque Baixo -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Produtos com Estoque Baixo</h3>
        <button class="btn btn-primary btn-sm" onclick="exportarEstoqueBaixo()">Exportar</button>
    </div>
    
    <div class="table-container">
        <table class="table">
            <thead>
                <tr>
                    <th>Produto</th>
                    <th>Estoque Atual</th>
                    <th>Preço</th>
                </tr>
            </thead>
            <tbody id="estoqueBaixoTable">
                <tr>
                    <td colspan="3" class="text-center">Carregando...</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<!-- Clientes Mais Ativos -->
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Clientes Mais Ativos</h3>
        <button class="btn btn-primary btn-sm" onclick="exportarClientesMaisAtivos()">Exportar</button>
    </div>
    
    <div class="table-container">
        <table class="table">
            <thead>
                <tr>
                    <th>Cliente</th>
                    <th>Email</th>
                    <th>Total de Compras</th>
                    <th>Total Gasto</th>
                </tr>
            </thead>
            <tbody id="clientesMaisAtivosTable">
                <tr>
                    <td colspan="4" class="text-center">Carregando...</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<script>
let dataInicio = '';
let dataFim = '';

document.addEventListener('DOMContentLoaded', function() {
    // Definir datas padrão (último mês)
    const hoje = new Date();
    const umMesAtras = new Date(hoje.getFullYear(), hoje.getMonth() - 1, hoje.getDate());
    
    document.getElementById('dataFim').value = hoje.toISOString().split('T')[0];
    document.getElementById('dataInicio').value = umMesAtras.toISOString().split('T')[0];
    
    carregarRelatorios();
});

async function carregarRelatorios() {
    await carregarResumoGeral();
    await carregarProdutosMaisVendidos();
    await carregarEstoqueBaixo();
    await carregarClientesMaisAtivos();
    
    if (dataInicio && dataFim) {
        await carregarVendasPorPeriodo();
    }
}

async function carregarResumoGeral() {
    const response = await Relatorios.resumoGeral(dataInicio, dataFim);
    if (response.success) {
        const data = response.data;
        document.getElementById('resumoVendas').textContent = data.total_vendas || 0;
        document.getElementById('resumoFaturamento').textContent = Utils.formatCurrency(data.total_faturamento || 0);
        document.getElementById('resumoTicketMedio').textContent = Utils.formatCurrency(data.ticket_medio || 0);
        document.getElementById('resumoEstoqueBaixo').textContent = data.produtos_estoque_baixo || 0;
    }
}

async function carregarVendasPorPeriodo() {
    if (!dataInicio || !dataFim) {
        document.getElementById('vendasPeriodoTable').innerHTML = 
            '<tr><td colspan="3" class="text-center">Selecione um período para visualizar os dados</td></tr>';
        return;
    }
    
    const response = await Relatorios.vendasPorPeriodo(dataInicio, dataFim);
    if (response.success) {
        const tbody = document.getElementById('vendasPeriodoTable');
        
        if (response.data.length > 0) {
            tbody.innerHTML = response.data.map(item => `
                <tr>
                    <td>${new Date(item.data).toLocaleDateString('pt-BR')}</td>
                    <td>${item.total_vendas}</td>
                    <td>${Utils.formatCurrency(item.total_faturamento)}</td>
                </tr>
            `).join('');
        } else {
            tbody.innerHTML = '<tr><td colspan="3" class="text-center">Nenhuma venda encontrada no período</td></tr>';
        }
    }
}

async function carregarProdutosMaisVendidos() {
    const response = await Relatorios.produtosMaisVendidos(dataInicio, dataFim, 10);
    if (response.success) {
        const tbody = document.getElementById('produtosMaisVendidosTable');
        
        if (response.data.length > 0) {
            tbody.innerHTML = response.data.map(produto => `
                <tr>
                    <td>${produto.nome}</td>
                    <td>${produto.total_vendido}</td>
                    <td>${Utils.formatCurrency(produto.total_faturamento)}</td>
                </tr>
            `).join('');
        } else {
            tbody.innerHTML = '<tr><td colspan="3" class="text-center">Nenhum produto vendido no período</td></tr>';
        }
    }
}

async function carregarEstoqueBaixo() {
    const response = await Relatorios.estoqueBaixo(10);
    if (response.success) {
        const tbody = document.getElementById('estoqueBaixoTable');
        
        if (response.data.length > 0) {
            tbody.innerHTML = response.data.map(produto => `
                <tr>
                    <td>${produto.nome}</td>
                    <td><span style="color: ${produto.estoque <= 5 ? '#dc3545' : '#ffc107'}">${produto.estoque}</span></td>
                    <td>${Utils.formatCurrency(produto.preco)}</td>
                </tr>
            `).join('');
        } else {
            tbody.innerHTML = '<tr><td colspan="3" class="text-center">Nenhum produto com estoque baixo</td></tr>';
        }
    }
}

async function carregarClientesMaisAtivos() {
    const response = await Relatorios.clientesMaisAtivos(dataInicio, dataFim, 10);
    if (response.success) {
        const tbody = document.getElementById('clientesMaisAtivosTable');
        
        if (response.data.length > 0) {
            tbody.innerHTML = response.data.map(cliente => `
                <tr>
                    <td>${cliente.nome}</td>
                    <td>${cliente.email || '-'}</td>
                    <td>${cliente.total_compras}</td>
                    <td>${Utils.formatCurrency(cliente.total_gasto)}</td>
                </tr>
            `).join('');
        } else {
            tbody.innerHTML = '<tr><td colspan="4" class="text-center">Nenhum cliente ativo no período</td></tr>';
        }
    }
}

function aplicarFiltros() {
    dataInicio = document.getElementById('dataInicio').value;
    dataFim = document.getElementById('dataFim').value;
    
    if (dataInicio && dataFim) {
        if (new Date(dataInicio) > new Date(dataFim)) {
            Utils.showAlert('Data de início deve ser anterior à data de fim', 'warning');
            return;
        }
        carregarRelatorios();
    } else {
        Utils.showAlert('Selecione ambas as datas', 'warning');
    }
}

function limparFiltros() {
    document.getElementById('dataInicio').value = '';
    document.getElementById('dataFim').value = '';
    dataInicio = '';
    dataFim = '';
    carregarRelatorios();
}

// Funções de exportação (simuladas)
function exportarVendasPeriodo() {
    if (!dataInicio || !dataFim) {
        Utils.showAlert('Selecione um período primeiro', 'warning');
        return;
    }
    Utils.showAlert('Funcionalidade de exportação será implementada em versão futura', 'info');
}

function exportarProdutosMaisVendidos() {
    Utils.showAlert('Funcionalidade de exportação será implementada em versão futura', 'info');
}

function exportarEstoqueBaixo() {
    Utils.showAlert('Funcionalidade de exportação será implementada em versão futura', 'info');
}

function exportarClientesMaisAtivos() {
    Utils.showAlert('Funcionalidade de exportação será implementada em versão futura', 'info');
}
</script>

<?php include 'templates/footer.php'; ?>

