<?php
require_once 'includes/functions.php';

// Se já estiver logado, redirecionar para dashboard
if (isLoggedIn()) {
    header('Location: dashboard.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sistema de Vendas</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .login-container {
            background: white;
            padding: 3rem;
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 400px;
        }
        
        .login-header {
            text-align: center;
            margin-bottom: 2rem;
        }
        
        .login-title {
            font-size: 2rem;
            font-weight: bold;
            color: #333;
            margin-bottom: 0.5rem;
        }
        
        .login-subtitle {
            color: #666;
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <h1 class="login-title">Sistema de Vendas</h1>
            <p class="login-subtitle">Faça login para continuar</p>
        </div>
        
        <form id="loginForm">
            <div class="form-group">
                <label for="email" class="form-label">Email</label>
                <input type="email" id="email" name="email" class="form-control" required>
            </div>
            
            <div class="form-group">
                <label for="password" class="form-label">Senha</label>
                <input type="password" id="password" name="password" class="form-control" required>
            </div>
            
            <button type="submit" class="btn btn-primary" style="width: 100%;">
                <span class="btn-text">Entrar</span>
                <span class="loading d-none"></span>
            </button>
        </form>
        
        <div class="text-center mt-3">
            <p>Não tem uma conta? <a href="register.php" style="color: #667eea;">Cadastre-se</a></p>
        </div>
    </div>

    <script src="assets/js/main.js"></script>
    <script>
        document.getElementById('loginForm').addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const btnText = document.querySelector('.btn-text');
            const loading = document.querySelector('.loading');
            const submitBtn = document.querySelector('button[type="submit"]');
            
            // Mostrar loading
            btnText.classList.add('d-none');
            loading.classList.remove('d-none');
            submitBtn.disabled = true;
            
            const email = document.getElementById('email').value;
            const password = document.getElementById('password').value;
            
            try {
                await Auth.login(email, password);
            } finally {
                // Esconder loading
                btnText.classList.remove('d-none');
                loading.classList.add('d-none');
                submitBtn.disabled = false;
            }
        });
    </script>
</body>
</html>

