<?php
$pageTitle = 'Dashboard - Sistema de Vendas';
include 'templates/header.php';
?>

<div class="dashboard-grid">
    <div class="stat-card">
        <div class="stat-number" id="totalVendas">-</div>
        <div class="stat-label">Total de Vendas</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-number" id="totalFaturamento">-</div>
        <div class="stat-label">Faturamento Total</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-number" id="totalProdutos">-</div>
        <div class="stat-label">Produtos Cadastrados</div>
    </div>
    
    <div class="stat-card">
        <div class="stat-number" id="totalClientes">-</div>
        <div class="stat-label">Clientes Cadastrados</div>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h2 class="card-title">Produtos com Estoque Baixo</h2>
        <a href="produtos.php" class="btn btn-primary btn-sm">Ver Todos</a>
    </div>
    <div class="table-container">
        <table class="table">
            <thead>
                <tr>
                    <th>Produto</th>
                    <th>Estoque</th>
                    <th>Preço</th>
                </tr>
            </thead>
            <tbody id="estoqueBaixoTable">
                <tr>
                    <td colspan="3" class="text-center">Carregando...</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<div class="card">
    <div class="card-header">
        <h2 class="card-title">Produtos Mais Vendidos</h2>
        <a href="relatorios.php" class="btn btn-primary btn-sm">Ver Relatórios</a>
    </div>
    <div class="table-container">
        <table class="table">
            <thead>
                <tr>
                    <th>Produto</th>
                    <th>Quantidade Vendida</th>
                    <th>Faturamento</th>
                </tr>
            </thead>
            <tbody id="produtosMaisVendidosTable">
                <tr>
                    <td colspan="3" class="text-center">Carregando...</td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', async function() {
    // Carregar resumo geral
    const resumo = await Relatorios.resumoGeral();
    if (resumo.success) {
        const data = resumo.data;
        document.getElementById('totalVendas').textContent = data.total_vendas || 0;
        document.getElementById('totalFaturamento').textContent = Utils.formatCurrency(data.total_faturamento || 0);
        document.getElementById('totalProdutos').textContent = data.total_produtos || 0;
        document.getElementById('totalClientes').textContent = data.total_clientes || 0;
    }
    
    // Carregar produtos com estoque baixo
    const estoqueBaixo = await Relatorios.estoqueBaixo(5);
    if (estoqueBaixo.success) {
        const tbody = document.getElementById('estoqueBaixoTable');
        if (estoqueBaixo.data.length > 0) {
            tbody.innerHTML = estoqueBaixo.data.map(produto => `
                <tr>
                    <td>${produto.nome}</td>
                    <td><span style="color: ${produto.estoque <= 5 ? '#dc3545' : '#ffc107'}">${produto.estoque}</span></td>
                    <td>${Utils.formatCurrency(produto.preco)}</td>
                </tr>
            `).join('');
        } else {
            tbody.innerHTML = '<tr><td colspan="3" class="text-center">Nenhum produto com estoque baixo</td></tr>';
        }
    }
    
    // Carregar produtos mais vendidos
    const produtosMaisVendidos = await Relatorios.produtosMaisVendidos('', '', 5);
    if (produtosMaisVendidos.success) {
        const tbody = document.getElementById('produtosMaisVendidosTable');
        if (produtosMaisVendidos.data.length > 0) {
            tbody.innerHTML = produtosMaisVendidos.data.map(produto => `
                <tr>
                    <td>${produto.nome}</td>
                    <td>${produto.total_vendido}</td>
                    <td>${Utils.formatCurrency(produto.total_faturamento)}</td>
                </tr>
            `).join('');
        } else {
            tbody.innerHTML = '<tr><td colspan="3" class="text-center">Nenhuma venda registrada</td></tr>';
        }
    }
});
</script>

<?php include 'templates/footer.php'; ?>

