-- Dados de exemplo para o Sistema de Vendas
-- Execute este arquivo após criar a estrutura do banco de dados

USE sistema_vendas;

-- Inserir usuários de exemplo
INSERT INTO usuarios (nome, email, senha, tipo) VALUES
('Administrador', 'admin@sistema.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin'),
('João Silva', 'joao@vendedor.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'vendedor'),
('Maria Santos', 'maria@vendedor.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'vendedor');

-- Inserir clientes de exemplo
INSERT INTO clientes (nome, email, telefone, endereco) VALUES
('Carlos Oliveira', 'carlos@email.com', '(11) 99999-1111', 'Rua das Flores, 123 - São Paulo, SP'),
('Ana Costa', 'ana@email.com', '(11) 99999-2222', 'Av. Paulista, 456 - São Paulo, SP'),
('Pedro Souza', 'pedro@email.com', '(11) 99999-3333', 'Rua Augusta, 789 - São Paulo, SP'),
('Lucia Ferreira', 'lucia@email.com', '(11) 99999-4444', 'Rua Oscar Freire, 321 - São Paulo, SP'),
('Roberto Lima', 'roberto@email.com', '(11) 99999-5555', 'Av. Faria Lima, 654 - São Paulo, SP');

-- Inserir produtos de exemplo
INSERT INTO produtos (nome, descricao, preco, estoque) VALUES
('Notebook Dell Inspiron', 'Notebook Dell Inspiron 15 3000, Intel Core i5, 8GB RAM, 256GB SSD', 2499.99, 15),
('Mouse Logitech MX Master', 'Mouse sem fio Logitech MX Master 3, sensor de alta precisão', 349.99, 25),
('Teclado Mecânico Corsair', 'Teclado mecânico Corsair K95 RGB, switches Cherry MX', 899.99, 12),
('Monitor Samsung 24"', 'Monitor Samsung 24" Full HD, 75Hz, FreeSync', 799.99, 8),
('Webcam Logitech C920', 'Webcam Logitech C920 HD Pro, 1080p, microfone integrado', 299.99, 20),
('Headset HyperX Cloud', 'Headset gamer HyperX Cloud II, 7.1 surround, microfone removível', 449.99, 18),
('SSD Kingston 500GB', 'SSD Kingston NV2 500GB, NVMe PCIe 4.0, leitura até 3.500 MB/s', 299.99, 30),
('Memória RAM Corsair 16GB', 'Memória RAM Corsair Vengeance LPX 16GB (2x8GB) DDR4 3200MHz', 399.99, 22),
('Placa de Vídeo RTX 3060', 'Placa de vídeo NVIDIA GeForce RTX 3060 12GB GDDR6', 1899.99, 5),
('Fonte Corsair 650W', 'Fonte Corsair CV650 650W, 80 Plus Bronze, modular', 449.99, 14);

-- Inserir algumas vendas de exemplo
INSERT INTO vendas (cliente_id, usuario_id, data_venda, total) VALUES
(1, 2, '2024-01-15 10:30:00', 2849.98),
(2, 2, '2024-01-16 14:20:00', 1199.98),
(3, 3, '2024-01-17 09:15:00', 649.98),
(4, 2, '2024-01-18 16:45:00', 3299.97),
(5, 3, '2024-01-19 11:30:00', 749.98);

-- Inserir itens das vendas de exemplo
INSERT INTO itens_venda (venda_id, produto_id, quantidade, preco_unitario) VALUES
-- Venda 1
(1, 1, 1, 2499.99),
(1, 2, 1, 349.99),
-- Venda 2
(2, 3, 1, 899.99),
(2, 4, 1, 299.99),
-- Venda 3
(3, 5, 1, 299.99),
(3, 2, 1, 349.99),
-- Venda 4
(4, 1, 1, 2499.99),
(4, 4, 1, 799.99),
-- Venda 5
(5, 6, 1, 449.99),
(5, 5, 1, 299.99);

-- Atualizar estoque após as vendas
UPDATE produtos SET estoque = estoque - 2 WHERE id = 1; -- Notebook (2 vendidos)
UPDATE produtos SET estoque = estoque - 2 WHERE id = 2; -- Mouse (2 vendidos)
UPDATE produtos SET estoque = estoque - 1 WHERE id = 3; -- Teclado (1 vendido)
UPDATE produtos SET estoque = estoque - 2 WHERE id = 4; -- Monitor (2 vendidos)
UPDATE produtos SET estoque = estoque - 2 WHERE id = 5; -- Webcam (2 vendidos)
UPDATE produtos SET estoque = estoque - 1 WHERE id = 6; -- Headset (1 vendido)

-- Nota: A senha padrão para todos os usuários é "password"
-- Para fazer login use:
-- admin@sistema.com / password (Administrador)
-- joao@vendedor.com / password (Vendedor)
-- maria@vendedor.com / password (Vendedor)

