# Sistema de Vendas

Um sistema completo de vendas desenvolvido em PHP, CSS e MySQL com funcionalidades de gestão de vendas, estoque, clientes e relatórios diversos.

## Funcionalidades

- **Autenticação de Usuários**: Sistema de login e registro com diferentes níveis de acesso
- **Gestão de Produtos**: CRUD completo para produtos com controle de estoque
- **Gestão de Clientes**: Cadastro e gerenciamento de clientes
- **Sistema de Vendas**: Interface para registrar vendas com carrinho de compras
- **Relatórios**: Diversos relatórios de vendas, estoque e clientes
- **Design Responsivo**: Interface adaptável para desktop e mobile

## Requisitos do Sistema

- PHP 7.4 ou superior
- MySQL 5.7 ou superior
- Servidor web (Apache/Nginx)
- Extensões PHP: PDO, PDO_MySQL

## Instalação

1. **Configurar o Banco de Dados**
   - Crie um banco de dados MySQL
   - Execute o script `database.sql` para criar as tabelas
   - Configure as credenciais no arquivo `config/database.php`

2. **Configurar o Servidor Web**
   - Coloque os arquivos na pasta do servidor web
   - Configure o DocumentRoot para a pasta do sistema
   - Certifique-se de que o PHP está funcionando

3. **Configurar Permissões**
   - Dê permissões de escrita para a pasta do sistema (se necessário)

## Configuração

### Banco de Dados

Edite o arquivo `config/database.php` com suas credenciais:

```php
private $host = 'localhost';
private $db_name = 'sistema_vendas';
private $username = 'seu_usuario';
private $password = 'sua_senha';
```

### Primeiro Acesso

1. Acesse o sistema pelo navegador
2. Clique em "Cadastre-se" para criar o primeiro usuário
3. Escolha o tipo "Administrador" para ter acesso completo
4. Faça login com as credenciais criadas

## Estrutura do Projeto

```
sistema_vendas/
├── assets/
│   ├── css/
│   │   └── style.css
│   ├── js/
│   │   └── main.js
│   └── images/
├── config/
│   └── database.php
├── includes/
│   └── functions.php
├── modules/
│   ├── auth/
│   │   └── auth.php
│   ├── clientes/
│   │   └── clientes.php
│   ├── produtos/
│   │   └── produtos.php
│   ├── vendas/
│   │   └── vendas.php
│   └── relatorios/
│       └── relatorios.php
├── templates/
│   ├── header.php
│   └── footer.php
├── clientes.php
├── dashboard.php
├── index.php
├── login.php
├── produtos.php
├── register.php
├── relatorios.php
├── vendas.php
└── database.sql
```

## Uso do Sistema

### Dashboard
- Visão geral do sistema com estatísticas principais
- Produtos com estoque baixo
- Produtos mais vendidos

### Produtos
- Cadastrar novos produtos
- Editar informações e preços
- Controlar estoque
- Buscar produtos

### Clientes
- Cadastrar clientes
- Editar informações de contato
- Buscar clientes

### Vendas
- Registrar novas vendas
- Selecionar produtos e quantidades
- Associar vendas a clientes
- Visualizar histórico de vendas

### Relatórios
- Vendas por período
- Produtos mais vendidos
- Clientes mais ativos
- Produtos com estoque baixo
- Resumo geral com filtros por data

## Segurança

- Senhas são criptografadas com hash seguro
- Validação de entrada em todos os formulários
- Proteção contra SQL Injection usando prepared statements
- Controle de sessão para autenticação

## Tecnologias Utilizadas

- **Backend**: PHP 7.4+
- **Banco de Dados**: MySQL
- **Frontend**: HTML5, CSS3, JavaScript (ES6+)
- **Design**: CSS Grid, Flexbox, Responsive Design
- **Segurança**: PDO, Password Hashing, Session Management

## Suporte

Para dúvidas ou problemas:
1. Verifique se todos os requisitos estão atendidos
2. Confirme a configuração do banco de dados
3. Verifique os logs de erro do servidor web
4. Certifique-se de que as extensões PHP necessárias estão instaladas

## Licença

Este projeto é fornecido como está, para fins educacionais e de demonstração.

